#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Fork Magma cityMod01.fsh   by   honestcactus   
//https://www.shadertoy.com/view/lXyGWV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
===========================================================
Original by Daizuukee https://www.shadertoy.com/view/wlKBDV
Help from the wonderful Berelium
===========================================================
*/

#define CityDepth 8
#define Paralax .03
#define CityWidth 1
#define BuildingWidth 10.0
    //BackCol defines the color values of background buildings, NOT sky
#define BackCol vec4(0.161,0.184,0.839,1)
    //This second BackCol changes between the two colors -->
//#define BackCol lerp(vec4(0.525,0.035,0.231,1),vec4(0.553,0.341,0.165,1),.1+.1*sin(iTime))
#define FrontCol vec4(0.396,0.122,0.396,1)
#define BalcCol vec4(0.129,0.063,0.196,1)

/*Remove for Low Quality -> */
#define HighQ
/**/

vec4 lerp(vec4 v1,vec4 v2,float t){
    return(v2-v1)*t+v1;
}

float random(vec2 st){
    return fract(sin(dot(st,
                vec2(12.9898,78.233)))*
            40000.5453123);
        }
        //Stars
        float noise(vec2 st){
            vec2 st0=floor(st);
            vec2 st1=0.5-cos((st-st0)*3.14)*0.5;
            float a0=random(vec2(int(st0.x),int(st0.y)));
            float a1=random(vec2(int(st0.x)+1,int(st0.y)));
            
            float a2=random(vec2(int(st0.x),int(st0.y)+1));
            float a3=random(vec2(int(st0.x)+1,int(st0.y)+1));
            
            float b0=(a1-a0)*st1.x+a0;
            
            float b1=(a3-a2)*st1.x+a2;
            return(b1-b0)*st1.y+b0;
            
        }
        
        bool isBuilding(vec2 uv){
            for(int j=-CityWidth;j<=CityWidth;j++){
                for(int n=0;n<5;n++){
                    float h=float(n)*.01+(random(vec2(floor(uv.x*BuildingWidth+float(j)),n))-.5)/2.+.25;
                    if(h>=uv.y&&
                        fract(uv.x*BuildingWidth)-.5-float(j)*1.5<float(CityWidth+1)*1.-float(n)/7.+fract(floor((h-uv.y)*100.*random(vec2(floor(uv.x*BuildingWidth))))/2.)*.1&&
                        fract(uv.x*BuildingWidth)-.5-float(j)*1.5>-float(CityWidth-2)*float(n)/7.-fract(floor((h-uv.y)*100.*random(vec2(floor(uv.x*BuildingWidth))))/2.)*.1){
                            return true;
                        }
                    }
                }
                return false;
            }
            
            bool isBalc(vec2 uv){
                return uv.y<.3||
                (uv.y<.4&&uv.y>.37)||
                (uv.y<.4&&fract((uv.x+iTime*.35)*10.)<.2);
            }

            
            //Calculates Balc colors
           //void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
                fragColor = vec4(0);
                vec2 uv=fragCoord/iResolution.xy;
                vec2 sv=uv;
                uv+=noise(uv*1.+iTime)*.002;
                uv.x+=iTime/50.-947.2984;
                if(isBalc(uv)){
                    if(isBalc(uv+vec2(.005,0))){
                        if(isBalc(vec2(uv.x+(sv.x-.5)*(sv.y-.3),.5-uv.y))||uv.y>.2)
                        fragColor=BalcCol;
                        else
                        fragColor=lerp(BackCol,BalcCol,.5-uv.y/.5);
                    }
                    else
                    fragColor=BackCol;
                }
                else{
                    bool broke=false;
                    for(int i=0;i<CityDepth;i++){
                        float mult=iTime*Paralax*float(CityDepth-i);
                        if(isBuilding(uv+vec2(mult,0))){
                            fragColor+=lerp(BackCol,FrontCol,1./float(i+1));
                            broke=true;
                            break;
                        }
                        if(broke){
                            break;
                        }
                        else{
                            #ifdef HighQ
                            vec4 c=lerp(BackCol,FrontCol,1./float(i+1));
                            fragColor+=c*2.*max(0.,.7+.3*noise(vec2(uv.x+mult,float(i)*292.293))-sv.y);
                            if(fract(uv.x+mult+.2723)<.1){
                                fragColor+=vec4(0,0,.1,0)*max(0.,(8.-uv.y*10.));
                            }
                            #endif
                        }
                        uv.x*=1.1;
                        uv.y-=1./float(CityDepth)/3.5;
                    }
                    //Sky
                    if(!broke){
                        fragColor+=lerp(vec4(0.929,0.275,0.114,1),vec4(0.161,0.000,0.800,1.0),uv.y);
                        float f=noise(vec2(iTime*10.,0)+sv*iResolution.xy*0.5);
                        if(f>0.95&&noise(vec2(iTime*10.,0)+sv*50.0)>0.5)
                        fragColor+=(f-0.9)/0.1;
                    }
                }
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

